/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Screen;

import com.hoshino.cti.Screen.menu.AtmosphereCondensatorMenu;
import com.hoshino.cti.util.BiomeUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class AtmosphereCondensatorScreen
extends AbstractContainerScreen<AtmosphereCondensatorMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("cti:textures/gui/machine/gui_condensor.png");
    private static final int TEXTURE_SIZE = 16;
    public static Font font = Minecraft.m_91087_().f_91062_;
    public static final NumberFormat nf = NumberFormat.getIntegerInstance();

    public AtmosphereCondensatorScreen(AtmosphereCondensatorMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    protected void m_7286_(PoseStack poseStack, float v, int i, int i1) {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(poseStack, x, y, 0, 0, this.f_97726_, this.f_97727_);
        this.drawProgress(poseStack, x, y);
        this.drawFE(poseStack, x, y);
    }

    protected void drawProgress(PoseStack poseStack, int x, int y) {
        if (((AtmosphereCondensatorMenu)this.f_97732_).isCrafting()) {
            int $$4 = this.f_97735_;
            int $$5 = this.f_97736_;
            int $$7 = ((AtmosphereCondensatorMenu)this.f_97732_).getProgressScale();
            this.m_93228_(poseStack, $$4 + 80, $$5 + 34, 176, 14, $$7 + 1, 16);
        }
    }

    protected void drawFE(PoseStack poseStack, int x, int y) {
        int $$4 = this.f_97735_;
        int $$5 = this.f_97736_;
        int $$7 = ((AtmosphereCondensatorMenu)this.f_97732_).getEnergyBarScale();
        this.m_93228_(poseStack, $$4 + 62, $$5 + 67, 176, 31, $$7, 12);
    }

    public void m_6305_(PoseStack poseStack, int mousex, int mousey, float delta) {
        List<Component> ls0;
        int leftPos1 = this.f_97735_;
        int topPos1 = this.f_97736_;
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mousex, mousey, delta);
        this.m_7025_(poseStack, mousex, mousey);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(leftPos1 + 116), (double)(topPos1 + 1), 0.0);
        this.drawFluid(poseStack, 16, ((AtmosphereCondensatorMenu)this.f_97732_).getFluidstack());
        poseStack.m_85849_();
        if (((AtmosphereCondensatorMenu)this.f_97732_).entity.m_58904_() != null) {
            AtmosphereCondensatorScreen.m_93243_((PoseStack)poseStack, (Font)font, (Component)Component.m_237113_((String)"\u7fa4\u7cfb: ").m_7220_((Component)Component.m_237115_((String)BiomeUtil.BiomekeyToString(BiomeUtil.getBiomeKey((Holder<Biome>)((AtmosphereCondensatorMenu)this.f_97732_).entity.m_58904_().m_204166_(((AtmosphereCondensatorMenu)this.f_97732_).entity.m_58899_()))))), (int)(leftPos1 + 8), (int)(topPos1 + 56), (int)0xDD00FF);
        }
        if (mousex >= leftPos1 + 62 && mousey >= topPos1 + 67 && mousex <= leftPos1 + 123 && mousey <= topPos1 + 80) {
            AtmosphereCondensatorScreen.m_93236_((PoseStack)poseStack, (Font)font, (String)(String.valueOf(((AtmosphereCondensatorMenu)this.f_97732_).getEnergy()) + "FE"), (int)(mousex + 8), (int)(mousey - 12), (int)0xFF6000);
            AtmosphereCondensatorScreen.m_93236_((PoseStack)poseStack, (Font)font, (String)("\u6700\u5927: " + String.valueOf(((AtmosphereCondensatorMenu)this.f_97732_).entity.getMaxEnergy()) + "FE"), (int)(mousex + 8), (int)mousey, (int)0xFF6000);
            AtmosphereCondensatorScreen.m_93236_((PoseStack)poseStack, (Font)font, (String)("\u6700\u5927: " + String.valueOf(((AtmosphereCondensatorMenu)this.f_97732_).entity.getEnergyPerTick()) + "FE/t"), (int)(mousex + 8), (int)(mousey + 12), (int)0xFF6000);
        }
        if (mousex >= leftPos1 + 116 && mousey >= topPos1 + 22 && mousex <= leftPos1 + 132 && mousey <= topPos1 + 62 && !(ls0 = this.getTooltip(((AtmosphereCondensatorMenu)this.f_97732_).getFluidstack(), (TooltipFlag)TooltipFlag.Default.NORMAL)).isEmpty()) {
            int b = ls0.size();
            for (int i = 0; i < b; ++i) {
                AtmosphereCondensatorScreen.m_93243_((PoseStack)poseStack, (Font)font, (Component)ls0.get(i), (int)(mousex + 8), (int)(mousey - 12 + 8 * i), (int)0xAAFF00);
            }
        }
    }

    public void drawFluid(PoseStack poseStack, int width, FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        int fluidColor = this.getColorTint(fluidStack);
        if (fluid.m_6212_(Fluids.f_76191_)) {
            return;
        }
        TextureAtlasSprite fluidSprite = this.getFluidStillSprite(fluidStack);
        int height = ((AtmosphereCondensatorMenu)this.f_97732_).getFluidBarScale();
        if (height <= 0) {
            height = 1;
        }
        if (height >= 60) {
            height = 60;
        }
        AtmosphereCondensatorScreen.drawTiledSprite(poseStack, 16, 60, fluidColor, height, fluidSprite);
    }

    public TextureAtlasSprite getFluidStillSprite(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation fluidStill = renderProperties.getStillTexture();
        Minecraft mc = Minecraft.m_91087_();
        return (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
    }

    public int getColorTint(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid);
        return renderProperties.getTintColor();
    }

    private static void setGLCoLorFromInt(int coLor) {
        float red = (float)(coLor >> 16 & 0xFF) / 255.0f;
        float green = (float)(coLor >> 8 & 0xFF) / 255.0f;
        float bLue = (float)(coLor & 0xFF) / 255.0f;
        float alpha = (float)(coLor >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)bLue, (float)alpha);
    }

    private static void drawTiledSprite(PoseStack poseStack, int tiledWidth, int tiledHeight, int color, long scaledAmount, TextureAtlasSprite sprite) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        AtmosphereCondensatorScreen.setGLCoLorFromInt(color);
        int xTileCount = tiledWidth / 16;
        int xRemainder = tiledWidth - xTileCount * 16;
        long yTileCount = scaledAmount / 16L;
        long yRemainder = scaledAmount - yTileCount * 16L;
        int yStart = tiledHeight;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int yTile = 0;
            while ((long)yTile <= yTileCount) {
                int width = xTile == xTileCount ? xRemainder : 16;
                long height = (long)yTile == yTileCount ? yRemainder : 16L;
                int x = xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width > 0 && height > 0L) {
                    long maskTop = 16L - height;
                    int maskRight = 16 - width;
                    AtmosphereCondensatorScreen.drawTextureWithMasking(matrix, x, y, sprite, maskTop, maskRight, 100.0f);
                }
                ++yTile;
            }
        }
    }

    private static void drawTextureWithMasking(Matrix4f matrix, float xCoord, float yCoord, TextureAtlasSprite textureSprite, long maskTop, int maskRight, float zLevel) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_85982_(matrix, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public List<Component> getTooltip(FluidStack fluidStack, TooltipFlag tooltipFlag) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        if (fluidStack.isEmpty()) {
            return tooltip;
        }
        Component displayName = fluidStack.getDisplayName();
        tooltip.add(displayName);
        long amount = fluidStack.getAmount();
        long milliBuckets = amount * 1000L / 1000L;
        if (Screen.m_96638_()) {
            MutableComponent amountString = Component.m_237110_((String)"cti.tooltip.liquid.amount.with.capacity", (Object[])new Object[]{nf.format(milliBuckets), nf.format(((AtmosphereCondensatorMenu)this.f_97732_).entity.FLUID_TANK.getCapacity())});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        } else {
            MutableComponent amountString = Component.m_237110_((String)"cti.tooltip.liquid.amount", (Object[])new Object[]{nf.format(milliBuckets)});
            tooltip.add((Component)amountString.m_130940_(ChatFormatting.GRAY));
        }
        return tooltip;
    }
}

